package com.bxm.localnews.user.account.impl.handler.gold;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.account.impl.rule.UsableGoldEnoughRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 消费可用金币
 * @author liujia
 * @date 2020/05/04 17:14
 */
@Component
public class ConsumeGoldAccountActionHandler extends AbstractGoldAccountActionHandler {
    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //可用金币减少
        storage.setUsableGold(source.getUsableGold() - context.getGoldNum());
        //消耗金币增加
        storage.setConsumeGold(source.getConsumeGold() + context.getGoldNum());
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.CONSUME_GOLD;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return Lists.newArrayList(UsableGoldEnoughRule.class);
    }

    @Override
    boolean isConsume() {
        return true;
    }
}
