package com.bxm.localnews.user.account.impl.rule;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import org.springframework.stereotype.Component;

/**
 * 可提现金额是否足够
 * @author liujia
 * @date 2020/05/04 18:24
 */
@Component
public class DrawableCashEnoughRule implements IRule {
    @Override
    public boolean apply(AccountActionContext context) {
        return context.getAmount().compareTo(context.getAccount().getDrawableCash()) <= 0;
    }
}
