package com.bxm.localnews.user.account.impl.rule;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import org.springframework.stereotype.Component;

/**
 * 判断可提现金额是否足够
 * @author liujia
 * @date 2020/05/04 18:10
 */
@Component
public class StabilizeCashEnoughRule implements IRule {
    @Override
    public boolean apply(AccountActionContext context) {
        return context.getAmount().compareTo(context.getAccount().getStabilizeCash()) <= 0;
    }
}
