package com.bxm.localnews.user.attribute;

import com.bxm.localnews.user.vo.UserFuns;
import java.util.List;

/**
 * 粉丝操作接口
 *
 * @author liujia
 */
public interface UserFunsService {

    /**
     * 添加粉丝
     *
     * @param userId 用户ID
     * @param funsId 粉丝ID
     */
    void addFuns(Long userId, Long funsId, byte type);

    /**
     * 移除用户的粉丝
     *
     * @param userId 用户ID
     * @param funsId 用户的粉丝ID
     */
    void removeFuns(Long userId, Long funsId);

    /**
     * 设置粉丝的状态为相互关注
     *
     * @param userId 用户ID
     * @param funsId 粉丝ID
     */
    void setFuns(Long userId, Long funsId, byte type);

    /**
     * 根据用户id列表获取用户粉丝列表
     *
     * @param userIdList 用户id列表
     * @return 用户粉丝列表
     */
    List<UserFuns> getUserFuns(List<Long> userIdList);

}
