package com.bxm.localnews.user.attribute;


import com.bxm.localnews.user.dto.UserPersonalInfoDTO;
import com.bxm.localnews.user.param.*;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.vo.Message;

/**
 * 用户个人资料相关接口
 */
public interface UserPersonalInfoService {


    /**
     * 异步执行一些不要紧的逻辑
     *
     * @param user                变更基础属性的用户
     * @param changeRedundancy    是否涉及到冗余信息的变更
     * @param changeRecommendAttr 是否涉及到推荐相关属性的变更
     */
    void asyncProcessing(User user, boolean changeRedundancy, boolean changeRecommendAttr);

    /**
     * 如其名
     */
    Message doUpdateHeadImg(UserHeadImgParam user);

    /**
     * 如其名
     */
    Message doUpdateNickname(UserNicknameParam user);

    /**
     * 如其名
     */
    Message doUpdateBirth(UserBirthParam user);

    /**
     * 如其名
     */
    Message doUpdateHometown(UserHomeTownParam user);

    /**
     * 如其名
     */
    Message doUpdateEmotion(UserEmotionParam user);

    /**
     * 如其名
     */
    Message doUpdateJob(UserJobParam user);

    /**
     * 如其名
     */
    Message doUpdatePersonalProfile(UserIntroductionParam user);

    /**
     * 如其名
     */
    Message doUpdateUserTag(UserTagParam user);

    /**
     * 如其名
     */
    Message doUpdateUserPhone(UserPhoneParam user);

    /**
     * 如其名
     */
    Message doUpdateUserSex(UserSexParam user);


    /**
     * 用途：更新用户的微信号
     */
    Message doUpdateUserWechat(UserWechatParam user);

    /**
     * 用途：更新用户的新手引导资料 场景：新用户在注册时，会强制要求他绑定基础的个人资料
     */
    Message doUpdateNewbieGuideInfo(NewbieGuideParam newbieGuideParam);

    /**
     * 如其名
     */
    UserPersonalInfoDTO getUserPersonalInfo(Long userId);

    /**
     * 用途：在用户创建时初始化用户的完善资料程度情况 这个方法别看，很蠢
     */
    Long initUserInfoCompleteStatus(User user);

    /**
     * 用途：检查用户个人资料完善度是否小于2
     */
    Boolean checkInfoCompleteStatus(Long userId);

    /**
     * 用途：用户可自定义自己的标签，如果和默认标签重复，则以自定义标签为准 场景：用户可以在<我的标签>和<个人主页>点击添加进入<创建标签>页面，从而增加新标签-
     *
     * @param customTagParam 自己看
     * @return 返回刚刚自定义的标签方便回显
     */
    Message saveCustomTag(CustomTagParam customTagParam);

    /**
     * 用途：是否弹出完善资料的弹窗
     */
    Boolean getCompleteInformationWindow(Long userId);

    /**
     * 修改订单隐私开关状态
     *
     * @param param
     * @return
     */
    Boolean orderPrivacyChange(OrderPrivacyChangeParam param);
}
