package com.bxm.localnews.user.attribute.impl;

import com.bxm.localnews.user.attribute.UserFunsService;
import com.bxm.localnews.user.domain.UserFunsMapper;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.UserFollowStatusEnum;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.vo.UserFuns;
import com.bxm.localnews.user.vo.UserFunsRecord;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserFunsServiceImpl implements UserFunsService {

    private final UserFunsMapper userFunsMapper;

    private final SequenceCreater sequenceCreater;

    private final UserService userService;

    @Autowired
    public UserFunsServiceImpl(UserFunsMapper userFunsMapper,
        SequenceCreater sequenceCreater,
        UserService userService) {
        this.userFunsMapper = userFunsMapper;
        this.sequenceCreater = sequenceCreater;
        this.userService = userService;
    }

    @Override
    public void addFuns(Long userId, Long funsId, byte type) {
        UserFunsRecord funs = new UserFunsRecord();
        funs.setUserId(userId);
        funs.setFunsUserId(funsId);
        funs.setType(type);

        int update = userFunsMapper.update(funs);
        if (0 == update) {
            funs.setId(sequenceCreater.nextLongId());
            userFunsMapper.insert(funs);
        }
    }

    @Override
    public void removeFuns(Long userId, Long funsId) {
        UserFunsRecord funs = new UserFunsRecord();
        funs.setUserId(userId);
        funs.setFunsUserId(funsId);
        funs.setType(UserFollowStatusEnum.UNFOLLOW.getCode());

        userFunsMapper.update(funs);
    }

    @Override
    public void setFuns(Long userId, Long funsId, byte type) {
        UserFunsRecord funs = new UserFunsRecord();
        funs.setUserId(userId);
        funs.setFunsUserId(funsId);
        funs.setType(type);

        userFunsMapper.update(funs);
    }

    @Override
    public List<UserFuns> getUserFuns(List<Long> userIdList) {
        List<UserFuns> resultList = new ArrayList<>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return resultList;
        }

        for (Long userId : userIdList) {
            List<UserFuns> userFuns = userFunsMapper.getFunsListByUserId(userId);
            if (!CollectionUtils.isEmpty(userFuns)) {
                List<Long> funsUserIdList = userFuns.stream().map(UserFuns::getFunsUserId).collect(Collectors.toList());
                List<UserInfoDTO> funsUserList = userService.getBatchUserInfo(funsUserIdList);

                if (!CollectionUtils.isEmpty(funsUserList)) {
                    Map<Long, String> userAreaMap = new HashMap<>();
                    for (UserInfoDTO userInfoDTO : funsUserList) {
                        userAreaMap.put(userInfoDTO.getId(), userInfoDTO.getLocationCode());
                    }

                    for (UserFuns userFun : userFuns) {
                        userFun.setFunsAreaCode(userAreaMap.get(userFun.getFunsUserId()));
                        resultList.add(userFun);
                    }
                }
            }
        }

        return resultList;
    }
}
