package com.bxm.localnews.user.attribute.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.user.attribute.UserTagService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserCommonTagMapper;
import com.bxm.localnews.user.domain.UserTagMapper;
import com.bxm.localnews.user.dto.UserTagDTO;
import com.bxm.localnews.user.vo.UserCommonTag;
import com.bxm.localnews.user.vo.UserTag;
import com.bxm.localnews.user.vo.UserTagRedis;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UserTagServiceImpl extends BaseService implements UserTagService {

    @Autowired
    private UserCommonTagMapper userCommonTagMapper;

    @Autowired
    private UserTagMapper userTagMapper;

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public List<UserTagDTO> listUserTag(Long userId) {

        //得到所有默认标签，做了二级缓存，应该很快的，不做异步了
        List<UserCommonTag> commonTagList = SpringContextHolder.getBean(this.getClass()).listUserCommonTag();

        //得到所有用户标签
        List<UserTag> userTagList = getUserTagFromRedisDb(userId);

        //标签列表返回体
        List<UserTagDTO> userTagDtoList = new ArrayList<>();

        //标签名称列表，用来去重的
        Set<String> labelList = new HashSet<>();

        //遍历用户标签列表，并封装结果
        userTagList.forEach(e -> {
            userTagDtoList.add(convertUserTag2UserTagDto(e));
            labelList.add(e.getLabel());
        });

        //遍历默认标签列表，加在用户标签的后面，根据标签名称去重
        commonTagList.forEach(e -> {
            if (!labelList.contains(e.getLabel())) {
                userTagDtoList.add(convertUserCommonTag2UserTagDto(e));
            }
        });

        return userTagDtoList;
    }

    /**
     * 用途如其名，不解释
     */
    @Override
    public UserTagDTO convertUserTag2UserTagDto(UserTag userTag) {
        UserTagDTO userTagDTO = new UserTagDTO();
        userTagDTO.setChooseFlag((byte) (userTag.getDeleteFlag() == 0 ? 1 : 0));
        userTagDTO.setDefaultFlag(userTag.getDefaultFlag());
        userTagDTO.setId(userTag.getId());
        userTagDTO.setLabel(userTag.getLabel());
        userTagDTO.setOrder(userTag.getOrder());
        return userTagDTO;
    }

    @Override
    public Map<Long, List<UserTag>> getBatchUserTag(Collection<Long> userIds) {
        Map<Long, List<UserTag>> userTagMap = new HashMap<>();
        List<String> paramList = userIds.stream().map(String::valueOf).collect(Collectors.toList());
        List<String> userTagCaches = redisHashMapAdapter.multiGet(RedisConfig.USER_TAG, paramList, String.class);
        userTagCaches.forEach(e -> {
            UserTagRedis userTagRedis = JSONObject.parseObject(e, UserTagRedis.class);
            userTagMap.put(userTagRedis.getUserId(), userTagRedis.getUserTagList());
        });
        return userTagMap;
    }

    /**
     * 用途如其名，不解释
     */

    private UserTagDTO convertUserCommonTag2UserTagDto(UserCommonTag userTag) {
        UserTagDTO userTagDTO = new UserTagDTO();
        userTagDTO.setChooseFlag((byte) 0);
        userTagDTO.setDefaultFlag((byte) 1);
        userTagDTO.setId(userTag.getId());
        userTagDTO.setLabel(userTag.getLabel());
        return userTagDTO;
    }

    @Override
    @Cacheable(value = "listUserCommonTag", sync = true)
    public List<UserCommonTag> listUserCommonTag() {
        return userCommonTagMapper.selectAll();
    }

    @Override
    public List<UserTag> getUserTagFromRedisDb(Long userId) {
        List<UserTag> userTagList;
        String userTagStr = this.redisHashMapAdapter.get(RedisConfig.USER_TAG, String.valueOf(userId), String.class);
        if (!StringUtils.isEmpty(userTagStr)) {
            UserTagRedis userTagRedis = JSONObject.parseObject(userTagStr, UserTagRedis.class);
            userTagList = userTagRedis.getUserTagList();
        } else {
            UserTagRedis userTagRedis;
            userTagList = this.userTagMapper.selectByUserId(userId);
            if (CollectionUtils.isEmpty(userTagList)) {
                //如果没有的话，就塞个空的数组进redis中，防止恶意请求不存在的用户id导致【缓存穿透】
                userTagRedis = UserTagRedis.buildEmptyUserTagRedis(userId);
            } else {
                userTagRedis = UserTagRedis.buildUserTagRedis(userId, userTagList);
            }
            this.redisHashMapAdapter.put(RedisConfig.USER_TAG, String.valueOf(userId), JSON.toJSONString(userTagRedis));
        }
        return userTagList;
    }
}
