/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.invite.bind;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author : jieli.xu
 * @date 2020/7/13 20:45
 * 海报分享绑定师徒关系
 */
@Component
public class PostersShareBindMethod extends AbstractBindInviteStrategy {

    private final InviteRecordService inviteRecordService;

    @Autowired
    public PostersShareBindMethod( InviteRecordService inviteRecordService) {
        this.inviteRecordService = inviteRecordService;
    }

    @Override
    protected Message preInvoke(UserInviteBindDTO userInviteBindDTO) {
        //海报分享：没有的话只插入邀请关系
        if(!userInviteBindDTO.getAlreadyHas()){
            userInviteBindDTO.getUserInviteHistoryBean().setType(InviteTypeEnum.POSTERS_SHARE.getName());
            userInviteBindDTO.getUserInviteHistoryBean().setState(AppConst.USER_STATE.NORMAL);
            userInviteBindDTO.setRelationTitle("海报分享");
            return Message.build(true);
        }
        return Message.build(false);
    }

    @Override
    protected Message afterInviteNormal(UserInviteBindDTO userInviteBindDTO) {
        Message message = super.afterInviteNormal(userInviteBindDTO);
        //插入邀请记录
        inviteRecordService.insertNormal(userInviteBindDTO.getInviteUserId(),userInviteBindDTO.getUserId());
        return message;
    }


    @Override
    protected Message afterInviteNotActive(UserInviteBindDTO userInviteBindDTO) {
        //添加邀请记录
        inviteRecordService.addInviteRecord(userInviteBindDTO.getInviteUserId(),userInviteBindDTO.getUserId(),userInviteBindDTO.getUser().getRegisterChannel());
        return Message.build(true);
    }

    @Override
    protected InviteBindMethodEnum getBindMethod() {
        return InviteBindMethodEnum.POSTERS_SHARE;
    }
}

