package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

/**
 * 通过激活码建立邀请关系的逻辑处理
 * @author liujia
 * @date 2020/05/12 14:03
 */
@Component
public class ActiveCodeInviteTypeProcessor extends AbstractInviteTypeProcessor {
    @Override
    public String obtainTitle(InviteProcessorContext context) {
        return "激活码";
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.ACTIVE_CODE;
    }



    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        return "的激活码邀请";
    }
}
