package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 默认的邀请类型处理器
 * @author liujia
 * @date 2020/05/11 15:35
 */
@Component
@Slf4j
public class DefaultInviteTypeProcessor extends AbstractInviteTypeProcessor {
    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.ALL;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        return defaultInviteMsg;
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        log.debug("未配置的邀请类型，不做处理:{}", context);
        return null;
    }

    @Override
    Message callback(InviteProcessorContext context) {
        log.info("使用默认的邀请处理逻辑，请求参数：{}", context);
        return Message.build();
    }
}
