package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

/**
 * 面对面邀请
 * @author liujia
 * @date 2020/05/12 14:03
 */
@Component
public class FaceInviteTypeProcessor extends AbstractInviteTypeProcessor {
    @Override
    public String obtainTitle(InviteProcessorContext context) {
        return "面对面邀请";
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.FACEINVITE;
    }



    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        return "的面对面邀请";
    }
}
