package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.user.integration.NewsIntegrationService;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.utils.MaxLengthStringBuilder;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 分享帖子邀请用户
 * @author liujia
 * @date 2020/05/11 17:01
 */
@Component
public class ForumInviteTypeProcessor extends AbstractInviteTypeProcessor {

    @Resource
    private NewsIntegrationService newsIntegrationService;

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.FORUM;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        if (StringUtils.isBlank(inviteHistory.getRelationTitle())) {
            return defaultInviteMsg;
        }

        return MaxLengthStringBuilder.builder(defaultColumnWidth)
                .appendImmutable("分享的《")
                .appendDynamic(inviteHistory.getRelationTitle())
                .appendImmutable("》帖子")
                .build();
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        if (context.getRelationId() == null) {
            return StringUtils.EMPTY;
        }
        //根据邀请人信息的relationId获取帖子标题
        ForumPostBriefInfoDto post = newsIntegrationService.getPostWithoutDetail(context.getRelationId());
        if (StringUtils.isBlank(post.getTitle())) {
            return StringUtils.EMPTY;
        }
        return post.getTitle();
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }
}
