package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

/**
 * 面对面邀请
 * @author liujia
 * @date 2020/05/12 14:03
 */
@Component
public class GoodsInviteTypeProcessor extends AbstractInviteTypeProcessor {
    @Override
    public String obtainTitle(InviteProcessorContext context) {
        return "商品分享邀请";
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.WST_GOODS_SHARE;
    }



    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        return "的商品分享邀请";
    }
}
