package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.dto.NewsBriefInfoDto;
import com.bxm.localnews.user.integration.NewsIntegrationService;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.utils.MaxLengthStringBuilder;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 通过新闻邀请用户的处理逻辑
 * @author liujia
 * @date 2020/05/11 15:45
 */
@Component
public class NewsInviteTypeProcessor extends AbstractInviteTypeProcessor {

    private final NewsIntegrationService newsIntegrationService;

    @Autowired
    public NewsInviteTypeProcessor(NewsIntegrationService newsIntegrationService) {
        this.newsIntegrationService = newsIntegrationService;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.NEWS;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        if (StringUtils.isBlank(inviteHistory.getRelationTitle())) {
            return defaultInviteMsg;
        }

        return MaxLengthStringBuilder.builder(defaultColumnWidth)
                .appendImmutable("分享的《")
                .appendDynamic(inviteHistory.getRelationTitle())
                .appendImmutable("》新闻")
                .build();
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        if (context.getRelationId() == null) {
            return StringUtils.EMPTY;
        }

        NewsBriefInfoDto newsInfo = newsIntegrationService.getNewsInfo(context.getRelationId());

        if (StringUtils.isBlank(newsInfo.getTitle())) {
            return StringUtils.EMPTY;
        }
        return newsInfo.getTitle();
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }
}
