package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

/**
 * 分享个人账号到站外邀请
 * @author liujia
 * @date 2020/05/12 14:12
 */
@Component
public class PersonalHomepageInviteProcessor extends AbstractInviteTypeProcessor {
    @Override
    public String obtainTitle(InviteProcessorContext context) {
        //以后可能需要记录具体分享的某个人
        return "个人主页";
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.PERSONAL_HOMEPAGE;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        return "分享的" + inviteHistory.getRelationTitle();
    }
}
