package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.dto.CommodityGoodsDTO;
import com.bxm.localnews.user.integration.CommodityIntegrationService;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.utils.MaxLengthStringBuilder;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 分享返利商品形成邀请关系
 * @author liujia
 * @date 2020/05/11 20:54
 */
@Component
public class RebateInviteTypeProcessor extends AbstractInviteTypeProcessor {

    private final CommodityIntegrationService commodityIntegrationService;

    @Autowired
    public RebateInviteTypeProcessor(CommodityIntegrationService commodityIntegrationService) {
        this.commodityIntegrationService = commodityIntegrationService;
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        if (context.getRelationId() == null) {
            return StringUtils.EMPTY;
        }

        CommodityGoodsDTO goods = commodityIntegrationService.getBriefGoodsById(context.getRelationId());

        if (null != goods && StringUtils.isNotBlank(goods.getCommodityTitle())) {
            return goods.getCommodityTitle();
        }

        return StringUtils.EMPTY;
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.REBATE;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        if (StringUtils.isBlank(inviteHistory.getRelationTitle())) {
            return defaultInviteMsg;
        }

        return MaxLengthStringBuilder.builder(defaultColumnWidth)
                .appendImmutable("分享的《")
                .appendDynamic(inviteHistory.getRelationTitle())
                .appendImmutable("》商品")
                .build();
    }
}
