package com.bxm.localnews.user.login;

import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.newidea.component.vo.Message;

/**
 * Created by Administrator on 2018/2/28.
 */
public interface UserAuthService {

    /**
     * 添加三方登录绑定
     */
    int addUserAuth(Byte type, Long userId, String identifier, String credential);

    /**
     * 根据openId查看用户是否存在当前系统中
     */
    UserAuth selectByUserAuth(Byte type, String openId);

    /**
     * 获取APP用户提现的openId
     */
    UserAuth selectByUserAuth(Long userId, Byte type);

    /**
     * 添加用户鉴权信息
     */
    Message addUserAuthByWeixin(Long userId, String unionId, String openId);

    /**
     * 添加授权登录认证信息
     */
    void saveAuth(Long userId, LoginInfo loginInfo);

    /**
     * 检测微信号（第三方）是否已被其他账号绑定 根据登录类型和登录信息查询是否已经被绑定
     */
    Message checkBindExist(Byte loginType, String loginName);

}
