package com.bxm.localnews.user.login.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.user.login.ChuanglanFlashService;
import com.bxm.localnews.user.param.ChuangLanLoginParam;
import com.bxm.localnews.user.properties.CommonProperties;
import com.bxm.localnews.user.utils.AESUtils;
import com.bxm.localnews.user.utils.MD5;
import com.bxm.localnews.user.utils.OkHttpUtil;
import com.bxm.localnews.user.utils.SignUtils;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class ChuanglanFlashServiceImpl implements ChuanglanFlashService {

    private static final String SUCCESS_CODE = "200000";

    /**
     * 免密登录后台url
     */
    private static final String FLASH_LOGIN_URL = "https://api.253.com/open/flashsdk/mobile-query";

    @Resource
    private CommonProperties commonProperties;

    @Override
    public String getPhone(ChuangLanLoginParam param) {
        String appId = commonProperties.getChuanglanAppId().get(param.getPlatform());
        String appKey = commonProperties.getChuanglanAppIdDes().get(appId);

        log.info("请求闪验参数：[{}]", param);

        if (StringUtils.isNotBlank(commonProperties.getChuanglanMockPhone())) {
            String phone = commonProperties.getChuanglanMockPhone();
            log.debug("研发环境，返回模拟的创蓝闪验手机号码:{}", phone);
            return phone;
        }

        JSONObject result = tokenExchangeMobileRequest(param, appKey, appId);

        if (null == result) {
            log.warn("无法解析闪验的返回结果，请求参数：{}", param);
            return null;
        }

        //返回码 200000为成功
        String code = result.getString("code");
        if (SUCCESS_CODE.equals(code)) {
            String dataStr = result.getString("data");
            JSONObject dataObj = JSONObject.parseObject(dataStr);
            String mobile = dataObj.getString("mobileName");

            try {
                String key = MD5.getMD5Code(appKey);
                mobile = AESUtils.decrypt(mobile, key.substring(0, 16), key.substring(16));

                log.info("请求完成，请求参数：[{}],手机号码：[{}],返回值：[{}]", param, mobile, result);
            } catch (Exception e) {
                log.error("解析闪验返回值错误，请求参数：[{}]，返回值：[{}]", param, result);
                log.error(e.getMessage(), e);
                return null;
            }
            //解密后的手机号码
            return mobile;
        } else {
            log.error("闪验返回状态错误，请求参数：[{}]，返回值：[{}]", param, result);
        }
        return null;
    }

    private JSONObject tokenExchangeMobileRequest(ChuangLanLoginParam param, String appKey, String appId) {
        try {
            Map<String, String> params = new HashMap<>();
            params.put("token", param.getFlashToken());
            params.put("appId", appId);
            //可以不传，不传则解密直接使用AES解密
            params.put("encryptType", "0");
            params.put("sign", SignUtils.getSign(params, appKey));

            JSONObject jsonObject = OkHttpUtil.postRequest(FLASH_LOGIN_URL, params);
            if (null != jsonObject) {
                return jsonObject;
            }
        } catch (Exception e) {
            log.error("客户端请求参数：{}", param);
            log.error(e.getMessage(), e);
        }

        return null;
    }
}