package com.bxm.localnews.user.login.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.domain.UserLoginHistoryMapper;
import com.bxm.localnews.user.login.UserLoginHistoryService;
import com.bxm.localnews.user.vo.UserLoginHistory;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

@Service
public class UserLoginHistoryServiceImpl extends BaseService implements UserLoginHistoryService {

    @Resource
    private UserLoginHistoryMapper userLoginHistoryMapper;

    @Async
    @Override
    public void save(UserLoginHistory userLoginHistory) {
        userLoginHistoryMapper.insertSelective(userLoginHistory);
    }

    @Override
    public Message isDeviceExist(Long userId, String deviceId) {
        if (null != deviceId) {
            List<UserLoginHistory> userLoginHistoryList = userLoginHistoryMapper.selectUserByEquipment(userId, deviceId);
            if (CollectionUtils.isEmpty(userLoginHistoryList)) {
                return Message.build(false).addParam("equipment", deviceId);
            } else {
                return Message.build(true).addParam("equipment", deviceId);
            }
        }
        return Message.build(true);
    }

    @Override
    public Message isDeviceExistByDeviceId(Long userId, String deviceId) {
        if (null == userId || StringUtils.isEmpty(deviceId)) {
            return Message.build(true);
        }
        List<UserLoginHistory> userLoginHistoryList = userLoginHistoryMapper.selectUserByEquipment(userId, deviceId);
        return Message.build(CollectionUtils.isEmpty(userLoginHistoryList));
    }

    @Override
    @Async
    public void save(String equipment, BasicParam basicParam, Long userId, String ip) {
        //8.保存用户登录信息(客户端时可以获取到设备信息的，另外的不行)
        if (PlatformEnum.ANDROID.getCode() == basicParam.getPlatform()
                || PlatformEnum.IOS.getCode() == basicParam.getPlatform()) {

            if (logger.isDebugEnabled()) {
                logger.debug("更新登录历史，devcId:[{}],equipment:[{}]", basicParam.getDevcId(), JSONObject.toJSON(equipment));
            }

            if (com.bxm.newidea.component.tools.StringUtils.isNoneEmpty(equipment)) {
                this.save(UserLoginHistory.buildUserLoginHistory(nextSequence(), userId, ip, equipment));
            }
        } else if (4 == basicParam.getPlatform() || PlatformEnum.APPLET.getCode() == basicParam.getPlatform()) {
            //大转盘和小程序都是获取不到设备信息的，所以固定存传过来的devcid就行，值为2
            this.save(UserLoginHistory.buildUserLoginHistory(nextSequence(), userId, ip, basicParam.getDevcId()));
        }
    }

    @Override
    public UserLoginHistory selectFirst(Long userId) {
        return userLoginHistoryMapper.selectFirstOrLastOne(userId, 0);
    }

    @Override
    public UserLoginHistory selectLast(Long userId) {
        return userLoginHistoryMapper.selectFirstOrLastOne(userId, 1);
    }
}
