/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.login.protocal;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.user.dto.ProtocalInfoStrategyDTO;
import com.bxm.localnews.user.param.UserClipboardParam;
import com.bxm.localnews.user.utils.ProtocalUtils;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : jieli.xu
 * @date 2020/7/14 11:08
 * 粘贴板内容处理器
 */
@Component
@Slf4j
public class ProtocalProcesser {
    private  final Map<Integer,AbstractProtocalStrategy> map;

    private final AbstractProtocalStrategy defaultProtocal;
    @Autowired
    public ProtocalProcesser (List<AbstractProtocalStrategy> list,
                              InviteProtocalMethod inviteProtocalMethod){
        map = new HashMap<>();
        if(!CollectionUtils.isEmpty(list)){
            list.forEach(abstractProtocalStrategy -> {
                map.put(abstractProtocalStrategy.getType(),abstractProtocalStrategy);
            });
        }
        this.defaultProtocal = inviteProtocalMethod;
    }

    /**
     * 处理粘贴板内容
     * @param userClipboardParam ： 客户端上传粘贴板内容参数
     * @return ： 处理结果
     */
    public void execProtocal(UserClipboardParam userClipboardParam){
        log.debug("粘贴板上传内容：{}", JSONObject.toJSONString(userClipboardParam));
        if(!CollectionUtils.isEmpty(userClipboardParam.getStoreProtocals())){
            for(int i =0; i<userClipboardParam.getStoreProtocals().size(); i++){
                ProtocalInfoStrategyDTO protocalInfoStrategyDTO = new ProtocalInfoStrategyDTO();
                protocalInfoStrategyDTO.setUserClipboardParam(userClipboardParam);
                if(this.doInit(protocalInfoStrategyDTO,userClipboardParam.getStoreProtocals().get(i))){
                    Message message = map.get(protocalInfoStrategyDTO.getType()).doInvokeProtocal(protocalInfoStrategyDTO);
                    log.info("处理粘贴板内容结果[{}]，处理结果[{}]",userClipboardParam.getStoreProtocals().get(i),JSONObject.toJSONString(message));
                }
            }
        }
    }

    /**
     * 初始化参数
     */
    private Boolean doInit(ProtocalInfoStrategyDTO param,String protocal){
        if(!protocal.startsWith("wst:")){
            return false;
        }
        //处理协议参数
        Map<String, String> dealWithValue = ProtocalUtils.dealWithPosters(protocal);
        if (null == dealWithValue) {
            return false;
        }
        //设置参数信息
        param.setParams(dealWithValue);
        param.setType(Integer.parseInt(dealWithValue.get("type")));
        return true;
    }
}
