package com.bxm.localnews.user.query.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.param.UserSearchPageParam;
import com.bxm.localnews.user.domain.UserQueryMapper;
import com.bxm.localnews.user.param.UserPushQueryParam;
import com.bxm.localnews.user.query.UserQueryService;
import com.bxm.newidea.component.vo.PageWarper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @author liujia
 * @date 2020-07-16 10:41
 **/
@Service
@Slf4j
public class UserQueryServiceImpl implements UserQueryService {

    @Resource
    private UserQueryMapper userQueryMapper;

    @Override
    public PageWarper<Long> queryUserByPushParam(UserSearchPageParam param) {
        UserPushQueryParam queryParam = adapt(param);

        return new PageWarper<>(userQueryMapper.getUserByPage(queryParam));
    }

    /**
     * 将推送参数转化为当前用户查询的详细条件
     * 请求参数中使用map进行传递，通过适配转化，防止混乱
     *
     * @param param 原始请求参数
     * @return 明确的查询参数
     */
    private UserPushQueryParam adapt(UserSearchPageParam param) {
        if (log.isDebugEnabled()) {
            log.debug("推送用户请求查询参数：{}", JSON.toJSONString(param));
        }

        UserPushQueryParam queryParam = new UserPushQueryParam();
        queryParam.setPageNum(param.getPageNum());
        queryParam.setPageSize(param.getPageSize());

        Map<String, Object> ruleParam = param.getRuleParam();
        if (ruleParam == null) {
            log.warn("分页查询推送信息，不存在参数，进行全量查询，请求参数：{}", JSON.toJSONString(param));
        } else {
            Object areaCodes = ruleParam.get("areaCodes");
            if (areaCodes instanceof List) {
                queryParam.setAreaCodes((List<String>) areaCodes);
            }
        }

        return queryParam;
    }
}
