package com.bxm.localnews.user.support.impl;

import com.bxm.localnews.user.domain.UserEquipmentMapper;
import com.bxm.localnews.user.dto.EquipmentDTO;
import com.bxm.localnews.user.dto.h5.ClientVersionDto;
import com.bxm.localnews.user.integration.BizIntegrationService;
import com.bxm.localnews.user.support.UserEquipmentService;
import com.bxm.localnews.user.vo.UserEquipment;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/4/16 14:52
 * @desc
 */
@Service
public class UserEquipmentServiceImpl implements UserEquipmentService {

    @Resource
    private UserEquipmentMapper userEquipmentMapper;

    @Resource
    private BizIntegrationService bizIntegrationService;

    @Override
    public UserEquipment selectByEquipment(String equipment) {
        return userEquipmentMapper.selectByEquipment(equipment);
    }

    @Override
    public Message addUserEquipment(UserEquipment userEquipment) {
        userEquipmentMapper.addEquipment(userEquipment);
        return Message.build();
    }

    @Override
    public Message checkExistEquipment(String equipment, String activityType) {
        EquipmentDTO equipmentDTO = bizIntegrationService.getDevice(equipment);
        if (null != equipmentDTO && StringUtils.isNoneEmpty(equipmentDTO.getId())) {
            boolean isEquipmentExist = userEquipmentMapper.countEquipment(equipmentDTO.getId(), activityType) > 0;
            return Message.build(isEquipmentExist).addParam("id", equipmentDTO.getId());
        }
        return Message.build(true);

    }

    @Override
    public ClientVersionDto queryClientVersion(Long userId, String curVer) {
        ClientVersionDto clientVersion = userEquipmentMapper.queryClientVersion(userId);

        if (null == clientVersion) {
            clientVersion = new ClientVersionDto();
            clientVersion.setCompareResult(-1);
            clientVersion.setVersion("1.0.0");
        } else {
            clientVersion.setCompareResult(StringUtils.compareVersion(curVer, clientVersion.getVersion()));
        }

        return clientVersion;
    }
}
