package com.bxm.localnews.user.support.impl;

import com.bxm.localnews.user.domain.UserInformMapper;
import com.bxm.localnews.user.param.UserInformParam;
import com.bxm.localnews.user.support.UserInformService;
import com.bxm.localnews.user.vo.UserInform;
import com.bxm.newidea.component.service.BaseService;
import java.util.Date;
import lombok.AllArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@AllArgsConstructor(onConstructor = @__(@Autowired))
public class UserInformServiceImpl extends BaseService implements UserInformService {

    private final UserInformMapper userInformMapper;

    @Override
    public Boolean userInformService(UserInformParam userInformParam) {
        UserInform userInform = new UserInform();
        BeanUtils.copyProperties(userInformParam, userInform);
        userInform.setAddTime(new Date());
        userInform.setResult(0);
        userInformMapper.insertSelective(userInform);
        return Boolean.TRUE;
    }
}
