package com.bxm.localnews.user.support.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.mq.common.constant.MessageTypeEnum;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.attribute.UserVisitService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserLocationHistoryMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.domain.UserStatisticsMapper;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.ExtraInviteStateEnum;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.localnews.user.event.ActiveActionEvent;
import com.bxm.localnews.user.event.LocationActionEvent;
import com.bxm.localnews.user.event.UserActionEvent;
import com.bxm.localnews.user.integration.*;
import com.bxm.localnews.user.invite.UserInviteService;
import com.bxm.localnews.user.login.UserParamCheckService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.model.MerchantUserDTO;
import com.bxm.localnews.user.param.UserLocationParam;
import com.bxm.localnews.user.properties.BizConfigProperties;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.support.UserInternalService;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vip.relation.MerchantRelationService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserLocationHistory;
import com.bxm.localnews.user.vo.UserVip;
import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.oss.config.AliyunOssProperties;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.*;
import com.bxm.newidea.component.vo.Message;
import com.google.common.eventbus.EventBus;
import com.sun.org.apache.xpath.internal.operations.Bool;
import lombok.AllArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Objects;

import static com.bxm.newidea.component.tools.StringUtils.isGrateOrEqualThan;
import static java.util.Objects.nonNull;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

@Service
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class UserInternalServiceImpl extends BaseService implements UserInternalService {

    private UserAccountService userAccountService;

    private UserMapper userMapper;

    private UserProperties userProperties;

    private RedisStringAdapter redisStringAdapter;

    private UserLocationHistoryMapper userLocationHistoryMapper;

    private LocationIntegrationService locationIntegrationService;

    private AliyunOSSService aliyunOSSService;

    private AliyunOssProperties aliyunOssProperties;

    private BizConfigProperties bizConfigProperties;

    private BizLogIntegrationService bizLogIntegrationService;

    private UserNewsIntegrationService userNewsIntegrationService;

    private AppVersionIntegrationService appVersionIntegrationService;

    private UserParamCheckService userParamCheckService;

    private UserService userService;

    private UserVisitService userVisitService;

    private UserStatisticsMapper userStatisticsMapper;

    private EventBus userActionEventBus;

    private MessageUserIntegrationService messageUserIntegrationService;

    private UserInviteService userInviteService;

    private UserVipService userVipService;

    private MerchantRelationService merchantRelationService;

    @Override
    public LocationDTO doPostingLocation(String code, Long userId, BasicParam basicParam, String ip) {
        Message message = userParamCheckService.checkPostLocationParam(code, userId);
        if (!message.isSuccess()) {
            logger.error(message.getLastMessage());
        }

        if (null == code) {
            code = bizConfigProperties.getLocationCode();
        }

        LocationDTO locationDTO = locationIntegrationService.getLocationByGeocode(code);

        if (Objects.equals(appVersionIntegrationService.getPublishState(basicParam), Boolean.TRUE)) {
            locationDTO.setEnablePaidPromote((byte) 0);
            locationDTO.setEnableCommunityContent(0);
            locationDTO.setEnableIndexPublish(0);
        }

        if (null != userId) {
            locationDTO.setPublishPostNum(userNewsIntegrationService.getPublishPostNum(userId));
            //第二天打开app，更新邀请关系
            if (Objects.equals(redisStringAdapter.hasKey(RedisConfig.NEW_USER_LOGIN.copy().appendKey(userId)), Boolean.FALSE)){
                userAccountService.updateInviteUserCash(userId, ExtraInviteStateEnum.LOGIN_TWICE);
            }
            //更新用户地理位置以及其他操作
            SpringContextHolder.getBean(UserInternalService.class).afterPostingLocation(locationDTO, userId, basicParam, ip);
        } else {
            locationDTO.setPublishPostNum(0);
        }

        // 判断版本 是否3.5.0以上
        if (nonNull(basicParam)
                && isNotBlank(basicParam.getCurVer())
                && isGrateOrEqualThan(basicParam.getCurVer(), "3.5.0")) {
            // 是的话 不返回发帖按钮
            locationDTO.setEnableIndexPublish(0);
        }

        return locationDTO;
    }

    @Override
    @Async
    public void afterPostingLocation(LocationDTO locationDTO, Long userId, BasicParam basicParam, String ip) {
        //查找用户原来的地理位置
        User user = this.userMapper.selectByPrimaryKey(userId);

        if (null != user && StringUtils.notEquals(user.getLocationCode(), locationDTO.getCode())) {
            String oldLocationCode = user.getLocationCode();

            user.setLocationCode(locationDTO.getCode());
            user.setLocationName(locationDTO.getName());

            //1.更新用户信息
            this.userMapper.updateLocationByPrimaryKeySelective(user);
            this.userService.loadUserToRedis(userId);

            //2.位置历史表新增
            UserLocationHistory userLocationHistory = new UserLocationHistory();
            userLocationHistory.setAddTime(new Date());
            userLocationHistory.setId(nextSequence());
            userLocationHistory.setLocationCode(locationDTO.getCode());
            userLocationHistory.setUserId(userId);
            userLocationHistoryMapper.insert(userLocationHistory);

            //4.埋点日志
            bizLogIntegrationService.changeArea(userId, locationDTO.getCode(), null);

            //5.上报用户推荐信息属性信息-地区code
            if (isNotBlank(locationDTO.getCode())) {
                UserActionEvent userActionEvent = LocationActionEvent.of()
                        .setLocationCode(locationDTO.getCode())
                        .setLocationName(locationDTO.getName())
                        .setOldLocationCode(oldLocationCode)
                        .setUserId(user.getId());
                userActionEventBus.post(userActionEvent);
            }
        } else if (null != user) {
            logger.warn("用户位置信息变更失败，用户ID：{},变更后的位置:{},用户的当前位置：{}",
                    userId,
                    locationDTO.getCode(),
                    user.getLocationCode());
        }

    }

    @Override
    public String getUserHeaderImg(Long userId) {
        UserInfoDTO userInfoDTO = userService.getUserCache(userId);
        if (userInfoDTO == null) {
            return userProperties.getDefaultHeadImgUrl();
        }

        String urlString = userInfoDTO.getHeadImg();
        if (StringUtils.isBlank(userInfoDTO.getHeadImg())) {
            return userProperties.getDefaultHeadImgUrl();
        }

        if (StringUtils.startsWith(urlString, aliyunOssProperties.getCdnUrl())) {
            logger.debug("hit cache headimg:{}", userId);
            return urlString;
        }

        try {
            String fileExt = FileUtils.getFilextension(urlString);
            if (FileTypeEnum.getContentType(fileExt) == null) {
                fileExt = FileTypeEnum.JPG.getExtName();
            }
            URL url = new URL(urlString);
            BufferedInputStream dis = new BufferedInputStream(url.openStream());
            int hashCode = (int) (userId % 10);
            String imgUrl = aliyunOSSService.upload(dis, "avatar/" + hashCode + "/" + userId + "." + fileExt);

            userInfoDTO.setHeadImg(imgUrl);
            this.userService.loadUserToRedis(userId);
            return imgUrl;
        } catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public UserBaseInfoDTO getUserPersonalCenterInfo(Long userId, int platform) {
        //得到用户基本信息
        UserInfoDTO user = this.userService.getUserCache(userId);
        if (null == user) {
            return null;
        }
        UserBaseInfoDTO userBaseInfoDTO = new UserBaseInfoDTO();

        userBaseInfoDTO.setNickname(StringUtils.isBlank(user.getNickname()) ? StringUtils.hideMobile(user.getPhone()) : user.getNickname());
        userBaseInfoDTO.setHeadImg(StringUtils.isBlank(user.getHeadImg()) ? userProperties.getDefaultHeadImgUrl() : user.getHeadImg());
        userBaseInfoDTO.setForumNum(user.getPostNum());

        // 处理安卓3.5.0版本之前本地存储手机号码丢失的问题，额外返回手机号码，使其进行本地存储
        if (PlatformEnum.ANDROID.getCode() == platform) {
            userBaseInfoDTO.setPhone(user.getPhone());
        }
        userBaseInfoDTO.setSex(user.getSex());
        userBaseInfoDTO.setAttentionNum(user.getAttentionNum());
        userBaseInfoDTO.setFanNum(user.getFanNum());
        userBaseInfoDTO.setPersonalProfile(user.getPersonalProfile());
        userBaseInfoDTO.setAllInterviewNum(userVisitService.getInterviewNumByUserId(userId));
        //邀请人数
        userBaseInfoDTO.setInviteNum(user.getInviteNum());
        userBaseInfoDTO.setMaterialFinished(false);
        userBaseInfoDTO.setUnReadFanNum(messageUserIntegrationService.getUnReadMessageNum(userId, MessageTypeEnum.ADD_FUNS));

        userBaseInfoDTO.setRedPoint(false);
        userBaseInfoDTO.setNoticeNum(0);
        //今天增加的访问数量
        userBaseInfoDTO.setTodayInterviewNum(userVisitService.getTodayVisitorNum(userId));
        //用户账号相关字段
        userBaseInfoDTO.setUserCashGoldDTO(userAccountService.getUserCashGold(userId));
        //用户最近的收徒列表
        userBaseInfoDTO.setInviteUserHeadImgList(userInviteService.getLastInviteUserHeadImgList(userId));
        //是否VIP
        setUserVip(userBaseInfoDTO, userId);

        // 订单隐私开关
        userBaseInfoDTO.setOrderPrivacy(Objects.isNull(user.getJudgeMarker())
                // 未设置状态就是默认的隐私开启状态
                || !BitOperatorUtil.getBitAsBoolean(user.getJudgeMarker(), LocalNewsUserJudgeMarkerEnum.ORDER_PRIVACY.getIndex()));

        return userBaseInfoDTO;
    }

    @Override
    public int countRegUser(String startTime, String endTime) {
        return userStatisticsMapper.countRegUser(startTime, endTime);
    }

    @Override
    public Boolean postUserPositionAndLoginInfo(UserLocationParam userLocationParam) {
        if (logger.isDebugEnabled()) {
            logger.debug("上报用户定位以及活跃信息:{}", JSON.toJSONString(userLocationParam));
        }

        LocationDTO locationByGeocode = locationIntegrationService.getLocationByGeocode(userLocationParam.getAreaCode());

        UserActionEvent userActionEvent = ActiveActionEvent.of()
                .setLastLoginTime(new Date())
                .setLongitude(userLocationParam.getLongitude())
                .setLatitude(userLocationParam.getLatitude())
                .setCurrentAreaCode(locationByGeocode.getCode())
                .setUserId(userLocationParam.getUserId());

        userActionEventBus.post(userActionEvent);

        return true;
    }

    /**
     * 设置用户vip信息
     *
     * @param userBaseInfoDTO 用户信息
     * @param userId          用户id
     */
    private void setUserVip(UserBaseInfoDTO userBaseInfoDTO, Long userId) {
        UserVip userVip = userVipService.getUserVipByUid(userId);

        boolean activeVip = userVip.getUsable();

        userBaseInfoDTO.setIsVip(userVipService.isVip(userId) ? 1 : 0);

        if (activeVip) {
            userBaseInfoDTO.setCardNo(userVip.getCard());
            userBaseInfoDTO.setActiveCode(userVip.getActiveCode());
            userBaseInfoDTO.setEndDate(DateUtils.formatDate(userVip.getExpiredDate()));
            userBaseInfoDTO.setLeftOpenNum(userVip.getLeftOpenNum());
        }

        //增加认证商家
        MerchantUserDTO merchantUserDTO = merchantRelationService.getRelationMerchant(userId);
        userBaseInfoDTO.setMerchantStatus(0);
        if (nonNull(merchantUserDTO)) {
            BeanUtils.copyProperties(merchantUserDTO, userBaseInfoDTO);
        }
    }
}
