package com.bxm.localnews.user.timer;

import com.bxm.localnews.user.domain.UserInviteHistoryMapper;
import com.bxm.localnews.user.invite.InviteProcessService;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.StringUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author liujia
 * @date 2020/05/12 17:00
 */
@Component
@Slf4j
public class FixUserInviteHistoryTitleTask extends AbstractCronTask<String> {

    @Autowired
    private UserInviteHistoryMapper userInviteHistoryMapper;

    @Autowired
    private InviteProcessService inviteProcessService;

    @Override
    protected ReturnT<String> service(String s) {
        //最多处理次数，防止后续有人逻辑写错也不至于死循环
        int maxTimes = 5;
        execFix(maxTimes);
        return ReturnT.SUCCESS;
    }

    private void execFix(int times) {
        if (times <= 0) {
            log.warn("修复收徒标题的处理次数使用完，此为异常情况，请关注是否有逻辑将标题设置为null");
            return;
        }

        List<UserInviteHistoryBean> emptyTitleList = userInviteHistoryMapper.queryEmptyTitleRecord();

        if (emptyTitleList.size() == 0) {
            return;
        }

        for (UserInviteHistoryBean historyBean : emptyTitleList) {
            String title = inviteProcessService.getInviteTitle(historyBean);

            if (null == title) {
                //避免空值，保证一条数据仅修复一次，如果需要触发修复，可以通过sql将title设置为null
                title = StringUtils.EMPTY;
            }
            historyBean.setRelationTitle(title);
            userInviteHistoryMapper.updateTitle(historyBean);
        }

        execFix(--times);
    }

    @Override
    public String taskName() {
        return "定期修复邀请徒弟信息中的标题";
    }

    @Override
    public String cron() {
        return "0 0/10 * * * ?";
    }

    @Override
    public String version() {
        return "1.0.0";
    }
}
