package com.bxm.localnews.user.timer;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.domain.InviteRecordMapper;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.param.InviteExpireTaskParam;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Component
@Slf4j
public class InviteRelationshipTask extends AbstractTaskCallback<InviteExpireTaskParam> {

    @Resource
    private InviteRecordMapper inviteRecordMapper;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    protected ReturnT<String> service(InviteExpireTaskParam param) {
        log.info("定时解除邀请关系任务参数：{}", JSONObject.toJSONString(param));
        if (null == param || null == param.getInvitedUserId()) {
            return ReturnT.FAIL;
        }

        AccountCashParam accountCashParam = new AccountCashParam();
        accountCashParam.setCashType("TEMP_CASH");
        accountCashParam.setAddTotal(false);

        if (null != param.getInviteUserId()) {
            List<Map<String, Object>> idAwardMapList = inviteRecordMapper
                    .getIdAndInvitedAward(param.getInviteUserId(), param.getInvitedUserId());
            if (!CollectionUtils.isEmpty(idAwardMapList)) {
                Long id = Long.valueOf(idAwardMapList.get(0).get("id").toString());
                BigDecimal award = new BigDecimal(idAwardMapList.get(0).get("award").toString());
                if (award.compareTo(new BigDecimal(0)) > 0) {
                    accountCashParam.setRelationId(id);
                    accountCashParam.setCash(award.multiply(new BigDecimal(-1)));
                    accountCashParam.setCashFlowType("INVALID_BOUNTY");

                    accountCashParam.setUserId(param.getInviteUserId());
                    SpringContextHolder.getBean(UserAccountService.class).addCash(accountCashParam);

                    accountCashParam.setCashFlowType("INVALID_PACKET");
                    accountCashParam.setUserId(param.getInvitedUserId());
                    SpringContextHolder.getBean(UserAccountService.class).addCash(accountCashParam);
                }
            }
            inviteRecordMapper.removeInviteRecord(param.getInviteUserId(), param.getInvitedUserId());
            inviteRecordMapper.removeUserInvite(param.getInvitedUserId());
        } else {
            BigDecimal tempCash = SpringContextHolder.getBean(UserAccountService.class).getAccountTempCash(param.getInvitedUserId());
            if (null != tempCash && tempCash.compareTo(new BigDecimal(0)) > 0) {
                accountCashParam.setUserId(param.getInvitedUserId());
                accountCashParam.setRelationId(null);
                accountCashParam.setCash(tempCash.multiply(new BigDecimal(-1)));
                accountCashParam.setCashFlowType("INVALID_PACKET");
                SpringContextHolder.getBean(UserAccountService.class).addCash(accountCashParam);
            }
        }

        removeCache(param.getInvitedUserId());
        //若24小时未登录app,则视为赏金过期
        inviteRecordMapper.updateReceiveRedPacket(param.getInvitedUserId());

        return ReturnT.SUCCESS;
    }

    private void removeCache(Long userId) {
        SpringContextHolder.getBean(UserService.class).removeUserCache(userId);
    }

    public static String generateTaskName(Long inviteUserId, Long invitedUserId) {
        return "inviteRelationTask" + inviteUserId + "_" + invitedUserId;
    }

}
