package com.bxm.localnews.user.timer;

import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.localnews.user.domain.UserStatisticsMapper;
import com.bxm.localnews.user.model.vo.UserStatisticsBean;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.inner.IntervalMap;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class RegStatisticsTask extends AbstractCronTask<String> {

    @Resource
    private UserProperties userProperties;

    @Resource
    private HttpClientService httpClientService;

    @Resource
    private UserStatisticsMapper userStatisticsMapper;

    @Resource
    private MessageSender messageSender;

    @Override
    protected ReturnT<String> service(String param) {
        IntervalMap intervalMap = DateUtils.getInterval(DateUtils.Interval.YESTERDAY);
        List<UserStatisticsBean> regUserList = userStatisticsMapper.regUser(intervalMap.getStartTime(), intervalMap.getEndTime());
        List<UserStatisticsBean> vipUserList = userStatisticsMapper.vipUser(intervalMap.getStartTime(), intervalMap.getEndTime());

        // 内容运营区域新增用户
        String statisticsDate = DateUtils.formatDate(intervalMap.getStartTime());
        StringBuilder content = new StringBuilder();
        content.append(statisticsDate).append(" 内容运营区域新注册用户：\n");
        int sum = 0;

        for (UserStatisticsBean areaGroup : regUserList) {
            if (Objects.equals(areaGroup.getEnable(), 1)) {
                sum += areaGroup.getTotal();
                content.append(areaGroup.getLocationName()).append(" : ").append(areaGroup.getTotal()).append("\n");
            }
        }
        content.append("共：[ ").append(sum).append(" ]人\n");

        DingtalkMessage message = new DingtalkMessage();
        message.setScene("reg");
        message.setContent(content.toString());

        messageSender.sendDingtalk(message);

        // 非内容运营区域的新注册用户
        content = new StringBuilder();
        content.append(statisticsDate).append(" 其他区域新注册用户：\n");
        sum = 0;

        for (UserStatisticsBean areaGroup : regUserList) {
            if (Objects.equals(areaGroup.getEnable(), 0)) {
                sum += areaGroup.getTotal();
                content.append(areaGroup.getLocationName()).append(" : ").append(areaGroup.getTotal()).append("\n");
            }
        }
        content.append("共：[ ").append(sum).append(" ]人\n");

        message = new DingtalkMessage();
        message.setScene("reg");
        message.setContent(content.toString());

        messageSender.sendDingtalk(message);

        // 昨日VIP激活数据
        content = new StringBuilder();
        content.append(statisticsDate).append(" VIP激活数据：\n");
        sum = 0;

        for (UserStatisticsBean areaGroup : vipUserList) {
            sum += areaGroup.getTotal();
            content.append(areaGroup.getLocationName()).append(" : ").append(areaGroup.getTotal()).append("\n");
        }
        content.append("共：[ ").append(sum).append(" ]人\n");

        message = new DingtalkMessage();
        message.setScene("reg");
        message.setContent(content.toString());

        messageSender.sendDingtalk(message);

        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "regStaticsTask";
    }

    @Override
    public String cron() {
        return "0 0 9 * * ?";
    }

    @Override
    public String description() {
        return "每日早上9点统计广德和富阳的注册人数和VIP人数";
    }

}
