package com.bxm.localnews.user.timer;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.auth.enums.AuthCodeEnum;
import com.bxm.localnews.user.auth.UserAuthCodeService;
import com.bxm.localnews.user.param.RemoveAuthCodeParam;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.List;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 移除用户权限定时任务
 */
@Component
@Slf4j
public class RemoveUserAuthTask extends AbstractTaskCallback<RemoveAuthCodeParam> {

    @Override
    protected ReturnT<String> service(RemoveAuthCodeParam removeAuthCodeParam) {
        UserAuthCodeService userAuthCodeService = SpringContextHolder.getBean(UserAuthCodeService.class);
        List<Integer> authCodeIndex = removeAuthCodeParam.getAuthCodeIndex();
        authCodeIndex.forEach(index -> {
            AuthCodeEnum codeEnum = AuthCodeEnum.getByIndex(index);
            if (Objects.nonNull(codeEnum)) {
                userAuthCodeService.removeAuthCode(removeAuthCodeParam.getUserId(), codeEnum);
            }
        });
        log.debug("移除用户权限定任务执行成功,param:[{}]", JSONObject.toJSONString(removeAuthCodeParam));
        return ReturnT.SUCCESS;
    }

    public static String generateTaskName(Long userId) {
        return "RemoveUserAuthTask:" + userId;
    }
}
