package com.bxm.localnews.user.timer;

import com.bxm.localnews.user.domain.UserInviteHistoryMapper;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.vo.Tuple;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.inner.IntervalMap;
import com.xxl.job.core.biz.model.ReturnT;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 用户收徒统计消息推送
 * 统计前一日有邀请成功的用户
 * @author liujia
 * @date 2020/05/19 11:04
 */
@Component
public class UserInvitePushTask extends AbstractCronTask<String> {

    private final UserInviteHistoryMapper userInviteHistoryMapper;

    private final PushMsgIntegrationService pushMsgIntegrationService;

    private final UserService userService;

    @Autowired
    public UserInvitePushTask(UserInviteHistoryMapper userInviteHistoryMapper,
                              PushMsgIntegrationService pushMsgIntegrationService,
                              UserService userService) {
        this.userInviteHistoryMapper = userInviteHistoryMapper;
        this.pushMsgIntegrationService = pushMsgIntegrationService;
        this.userService = userService;
    }

    @Override
    protected ReturnT<String> service(String param) {
        IntervalMap interval = DateUtils.getInterval(DateUtils.Interval.YESTERDAY);

        List<Tuple> collectByDate = userInviteHistoryMapper.getCollectByDate(interval.getStartTime(),
                interval.getEndTime());

        if (CollectionUtils.isNotEmpty(collectByDate)) {
            collectByDate.forEach(tuple -> {
                Long userId = Long.valueOf(tuple.getLabel());
                LocationUserInfoDTO location = userService.getLocationUserInfo(userId);
                pushMsgIntegrationService.pushUserInvite(userId, tuple.getTotal(), location);
            });
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "用户收徒统计信息推送";
    }

    @Override
    public String cron() {
        return "0 0 8 * * ?";
    }
}
