package com.bxm.localnews.user.vip;

import com.bxm.localnews.user.dto.vip.ActiveCodeDTO;
import com.bxm.localnews.user.model.ResultDTO;
import com.bxm.localnews.user.param.AddTimesParam;
import com.bxm.localnews.user.param.OfflineBindRelationParam;
import com.bxm.localnews.user.vip.code.ActiveCodeProcessContext;
import com.bxm.localnews.user.vo.vip.UserActiveCodeBean;
import com.bxm.newidea.component.vo.Message;

import java.util.List;

/**
 * VIP激活码相关接口
 *
 * @author liujia
 * @date 2020/6/2 10:20
 **/
public interface ActiveCodeService {

    /**
     * 根据激活码获取可用的激活码详细信息
     * 可用的激活码：剩余激活次数大于0，状态为正常
     *
     * @param activeCode 激活码
     * @return 激活码详细信息，如果激活码不存在将返回null
     */
    UserActiveCodeBean getUsableActiveCode(String activeCode);

    /**
     * 获取激活码对应的完整信息
     *
     * @param activeCode 激活码
     * @return 如果激活码不存在将返回null
     */
    UserActiveCodeBean getActiveCode(String activeCode);

    /**
     * 扣除一次激活码使用次数，如果使用次数等于小于0，则将激活码状态为设置为失效
     * 如果扣除失败，进行重试
     *
     * @param activeCode 激活码
     * @return 执行结果
     */
    Message decrementWithRetry(String activeCode);

    /**
     * 增加激活码使用次数，更新激活码的对应状态
     * 如果处理失败，将进行一定次数的重试
     *
     * @param activeCode 激活码
     * @return 处理结果
     */
    Message incrementWithRetry(String activeCode);

    /**
     * 给用户增加激活次数
     *
     * @param param 处理参数
     * @return 处理结果
     */
    Message addActiveTimes(AddTimesParam param);

    /**
     * 处理用户的激活码相关信息，根据不同的激活流程，设置用户对应逻辑的卡号和激活码
     *
     * @param context 处理上下文信息
     * @return 激活码相关信息
     */
    ActiveCodeDTO process(ActiveCodeProcessContext context);

    /**
     * 获取下一个激活码
     *
     * @return 激活码
     */
    String nextCode();

    /**
     * 获取下一批激活码
     *
     * @param limit 激活码数量
     * @return 申请的激活码
     */
    List<String> nextCode(Integer limit);

    /**
     * 执行批量导出卡号和激活码，同时落库
     *
     * @param areaCode 导出激活码所属的地区
     * @param limit    导出数量
     * @return 导出数据
     */
    List<ActiveCodeDTO> execBatchExport(String areaCode, int limit);

    /**
     * 执行预留激活码与所属商户的绑定逻辑，如果激活码已被使用，需要补充绑定上下级关系
     *
     * @param bindRelationParams 导入数据对应的绑定关系
     * @return 绑定出错的结果数据
     */
    List<ResultDTO> execBatchBind(List<OfflineBindRelationParam> bindRelationParams);
}


















