/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.vip.activation;

import com.bxm.localnews.user.enums.ActivationVipEnum;
import com.bxm.localnews.user.param.ActivationUserVipParam;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 激活VIP策略管理类
 *
 * @author : jieli.xu
 * @date 2020/5/14 16:57
 */
@Component
public class ActivationVipManager {
    private Map<ActivationVipEnum, AbstractActivationVipStrategy> mapActivationVip;

    @Autowired
    public ActivationVipManager(List<AbstractActivationVipStrategy> strategyList) {
        mapActivationVip = Maps.newHashMap();

        strategyList.forEach(strategy -> {
            mapActivationVip.put(strategy.getType(), strategy);
        });
    }

    /**
     * 查找匹配的激活策略进行处理
     *
     * @param param 激活参数
     * @return 激活结果
     */
    public Message activationVip(ActivationUserVipParam param) {
        // 将激活码转化为大写
        if (param.getCode() != null) {
            param.setCode(param.getCode().toUpperCase());
        }
        
        AbstractActivationVipStrategy strategy = mapActivationVip.get(param.getActivationVipEnum());
        return strategy.execActivationVip(param);
    }
}
