package com.bxm.localnews.user.vip.activation;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.constant.VipActivationChannel;
import com.bxm.localnews.user.constant.VipActiveCode;
import com.bxm.localnews.user.enums.ActivationVipEnum;
import com.bxm.localnews.user.param.ActivationUserVipParam;
import com.bxm.localnews.user.vo.UserVip;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

import java.time.LocalDate;

/**
 * 运营后台通过操作手动激活用户的VIP资格
 *
 * @author liujia
 * @date 2020/6/3 17:56
 **/
@Component
public class ManualActivationStrategy extends AbstractActivationVipStrategy {

    @Override
    protected Message preCheck(ActivationUserVipParam param) {
        UserVip userVip = getUserVipService().getUserVipByUid(param.getUserId());

        if (userVip.getUsable()) {
            return Message.build(false, "用户已经是VIP，不需要重复激活").addParam(VipActiveCode.KEY, VipActiveCode.EXISTS);
        }

        if (StringUtils.isBlank(param.getChannel())) {
            param.setChannel(VipActivationChannel.MANUAL);
        }
        return Message.build();
    }

    @Override
    protected void afterSuccess(ActivationUserVipParam param) {
    }

    @Override
    InviteTypeEnum getInviteType() {
        return InviteTypeEnum.WELFARE_VIP;
    }

    @Override
    ActivationVipEnum getType() {
        return ActivationVipEnum.MANUAL;
    }

    @Override
    int getDuration(ActivationUserVipParam param) {
        LocalDate current = LocalDate.now();
        LocalDate nextYear = LocalDate.now().plusYears(1);

        return (int) (nextYear.toEpochDay() - current.toEpochDay());
    }
}
