package com.bxm.localnews.user.vip.code;

import com.bxm.localnews.user.dto.vip.ActiveCodeDTO;
import com.bxm.localnews.user.enums.ActiveCodeTypeEnum;

/**
 * 激活码处理策略
 *
 * @author liujia
 * @date 2020/6/3 10:26
 **/
public interface IActiveCodeProcessStrategy {
    /**
     * 给用户设置新的激活码，返回对应的卡号
     *
     * @param context 激活码处理上下文
     * @return 用户的激活码、卡号、可用次数信息
     */
    ActiveCodeDTO process(ActiveCodeProcessContext context);

    /**
     * 当前策略匹配的激活码类型
     *
     * @return 激活码枚举定义
     */
    ActiveCodeTypeEnum match();
}
