package com.bxm.localnews.user.vip.code.impl;

import com.bxm.localnews.user.dto.vip.ActiveCodeDTO;
import com.bxm.localnews.user.enums.ActiveCodeTypeEnum;
import com.bxm.localnews.user.vip.code.ActiveCodeProcessContext;
import org.springframework.stereotype.Component;

/**
 * 如果用户VIP激活使用的渠道商的激活码
 * 使用渠道商的激活码，卡号则选用激活码对应的卡号，不重新生成
 *
 * @author liujia
 * @date 2020/6/3 15:50
 **/
@Component
public class ChannelCodeProcessStrategy extends AbstractCodeProcessStrategy {

    @Override
    public ActiveCodeDTO process(ActiveCodeProcessContext context) {
        String activeCode = getActiveCodeService().nextCode();
        // 渠道商的激活码对应的卡号作为当前用户的卡号
        // 这是在卡片仅可使用一次的情况，如果变为多次使用，这里就需要重新创建新的卡号了
        String cardNo = context.getSourceCodeInfo().getCardNo();

        context.setUserAreaCode(context.getSourceCodeInfo().getAreaCode());
        context.setNewActiveCode(activeCode);

        // 增加一条激活码关联记录
        saveActiveRelation(context);
        // 保存当前用户的新的激活码
        saveActiveCodeRecord(context, ActiveCodeTypeEnum.SUB);

        return ActiveCodeDTO.builder()
                .cardNo(cardNo)
                .activeCode(activeCode)
                .build();
    }

    @Override
    public ActiveCodeTypeEnum match() {
        return ActiveCodeTypeEnum.CHANNEL;
    }
}
