package com.bxm.localnews.user.vip.code.impl;

import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.vip.ActiveCodeDTO;
import com.bxm.localnews.user.enums.ActiveCodeTypeEnum;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.properties.UserVipProperties;
import com.bxm.localnews.user.vip.code.ActiveCodeProcessContext;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 内部手动直接激活
 *
 * @author liujia
 * @date 2020/6/3 20:01
 **/
@Component
public class ManualCodeProcessStrategy extends AbstractCodeProcessStrategy {

    @Autowired
    private UserService userService;

    @Autowired
    private UserVipProperties userVipProperties;

    @Override
    public ActiveCodeDTO process(ActiveCodeProcessContext context) {
        String cardNo = null;
        String activeCode = getActiveCodeService().nextCode();

        UserInfoDTO user = userService.getUserCache(context.getUserId());

        // 如果用户信息中包含地区，则创建卡号,否则将交由获取VIP信息时的逻辑进行卡号修正
        if (StringUtils.isNotBlank(user.getLocationCode())) {
            cardNo = vipCardService.nextCard(user.getLocationCode());
            context.setUserAreaCode(user.getLocationCode());
        }

        // 将激活码信息落库
        context.setNewCardNo(cardNo);
        context.setNewActiveCode(activeCode);

        saveActiveCodeRecord(context, ActiveCodeTypeEnum.SUB, userVipProperties.getDefaultManualCodeNum());

        return ActiveCodeDTO.builder()
                .activeCode(activeCode)
                .cardNo(cardNo)
                .build();
    }

    @Override
    public ActiveCodeTypeEnum match() {
        return ActiveCodeTypeEnum.MANUAL;
    }
}
