package com.bxm.localnews.user.vip.code.impl;

import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.vip.ActiveCodeDTO;
import com.bxm.localnews.user.enums.ActiveCodeTypeEnum;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.vip.code.ActiveCodeProcessContext;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 通过二级激活码激活VIP的相关处理流程
 *
 * @author liujia
 * @date 2020/6/3 15:53
 **/
@Component
public class SubCodeProcessStrategy extends AbstractCodeProcessStrategy {
    @Autowired
    private UserService userService;

    @Override
    public ActiveCodeDTO process(ActiveCodeProcessContext context) {
        String cardNo = null;
        String activeCode = getActiveCodeService().nextCode();

        UserInfoDTO user = userService.getUserCache(context.getUserId());
        // 优先使用用户的地区信息
        if (StringUtils.isNotBlank(user.getLocationCode())) {
            cardNo = vipCardService.nextCard(user.getLocationCode());
            context.setUserAreaCode(user.getLocationCode());
        } else if (StringUtils.isNotBlank(context.getSourceCodeInfo().getAreaCode())) {
            cardNo = vipCardService.nextCard(context.getSourceCodeInfo().getAreaCode());
            context.setUserAreaCode(context.getSourceCodeInfo().getAreaCode());
        }

        context.setNewCardNo(cardNo);
        context.setNewActiveCode(activeCode);

        // 增加一条激活码关联记录
        saveActiveRelation(context);
        // 保存当前用户的新的激活码
        saveActiveCodeRecord(context, ActiveCodeTypeEnum.SUB);

        return ActiveCodeDTO.builder()
                .cardNo(cardNo)
                .activeCode(activeCode)
                .build();
    }

    @Override
    public ActiveCodeTypeEnum match() {
        return ActiveCodeTypeEnum.SUB;
    }
}
