package com.bxm.localnews.user.vip.impl;

import com.bxm.localnews.user.vip.VipCardService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

import static com.bxm.localnews.user.constant.RedisConfig.VIP_CARD_INDEX_KEY;

@Service
@Slf4j
public class VipCardServiceImpl implements VipCardService {

    private final RedisStringAdapter redisStringAdapter;

    private static final long START_NUM = 100000;

    private static final String DEFAULT_AREA = "330100000000";

    private static int AREA_LENGTH = 6;

    @Autowired
    public VipCardServiceImpl(RedisStringAdapter redisStringAdapter) {
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public String nextCard(String areaCode) {
        if (StringUtils.isBlank(areaCode) || areaCode.length() < AREA_LENGTH) {
            areaCode = DEFAULT_AREA;
            log.error("创建VIP卡号，地区信息未传递或长度错误，使用了默认的地区：{}，参数地区：{}",
                    DEFAULT_AREA,
                    areaCode);
        }

        String subAreaCode = StringUtils.substring(areaCode, 0, AREA_LENGTH);
        KeyGenerator key = buildKey(subAreaCode);

        long cardIndex = redisStringAdapter.incrementWithDefault(key, START_NUM);

        return subAreaCode + String.format("%07d", cardIndex);
    }

    private KeyGenerator buildKey(String areaCode) {
        return VIP_CARD_INDEX_KEY.copy().appendKey(areaCode);
    }

    @Override
    public List<String> nextCard(String areaCode, int limit) {
        if (StringUtils.isBlank(areaCode) || areaCode.length() < AREA_LENGTH) {
            areaCode = DEFAULT_AREA;
            log.error("创建VIP卡号，地区信息未传递或长度错误，使用了默认的地区：{}，参数地区：{}",
                    DEFAULT_AREA,
                    areaCode);
        }

        String subAreaCode = StringUtils.substring(areaCode, 0, AREA_LENGTH);
        KeyGenerator key = buildKey(subAreaCode);

        List<String> cardNoList = new ArrayList<>(limit);

        if (!redisStringAdapter.hasKey(key)) {
            redisStringAdapter.set(key, START_NUM);
        }
        long cardIndex = redisStringAdapter.increment(key, limit);

        for (int i = limit - 1; i >= 0; i--) {
            cardNoList.add(subAreaCode + String.format("%07d", cardIndex - i));
        }

        return cardNoList;
    }
}
