package com.bxm.localnews.user.vip.relation.impl;

import com.bxm.localnews.user.integration.MerchantIntegrationService;
import com.bxm.localnews.user.model.MerchantUserDTO;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.vip.relation.MerchantRelationService;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

import static java.util.Objects.isNull;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * @author pf.w
 * @date 2020/7/16 19:10
 */

@Service
@Log4j2
public class MerchantRelationServiceImpl implements MerchantRelationService {

    private final MerchantIntegrationService merchantIntegrationService;

    private LoadingCache<Long, MerchantUserDTO> merchantCache;

    private final UserProperties userProperties;

    @Autowired
    public MerchantRelationServiceImpl(MerchantIntegrationService merchantIntegrationService,
                                       UserProperties userProperties) {
        this.merchantIntegrationService = merchantIntegrationService;
        this.userProperties = userProperties;

        initCache();
    }

    @Override
    public MerchantUserDTO getRelationMerchant(Long userId) {
        if (log.isDebugEnabled()) {
            log.debug("relation merchant userId : {}", userId);
        }

        if (isNull(userId)) {
            return null;
        }

        MerchantUserDTO merchantUserDTO = merchantCache.getUnchecked(userId);

        // 这一步操作是因为即使商家下架了，这边还是要显示商家标志
        if (userProperties.getForceShowMerchant()
                && isNotBlank(merchantUserDTO.getMerchantName())) {
            merchantUserDTO.setMerchantStatus(1);
        }

        return merchantUserDTO;
    }

    private void initCache() {
        merchantCache = CacheBuilder.newBuilder()
                .expireAfterWrite(2, TimeUnit.MINUTES)
                .maximumSize(5000)
                .build(new CacheLoader<Long, MerchantUserDTO>() {
                    @Override
                    public MerchantUserDTO load(Long key) throws Exception {
                        return merchantIntegrationService.getUserMerchantInfo(key);
                    }
                });
    }
}
