package com.bxm.spider.manager.facade.service;

import com.bxm.spider.manager.facade.model.PageContentVo;
import com.bxm.spider.manager.facade.model.PageDownloadDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @ClassName ContentDownloadFeignService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/2/28 15:57
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/2/28 15:57
 **/
@FeignClient(name = "manager-service")
public interface ContentDownloadFeignService {


    /**
     * 新闻后端使用的内容下载服务
     * @param pageDownloadDto
     * @return
     */
    @RequestMapping(value = "/spider/pageDownload",method = RequestMethod.POST)
    ResponseEntity<PageContentVo> pageDownload(@RequestBody PageDownloadDto pageDownloadDto);
}
