package com.bxm.openlog.extension.client.ws;

import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author zhangdong
 * @date 2025/2/13
 */
@Data
@ConfigurationProperties(prefix = WsOpenLogClientProperties.PREFIX)
public class WsOpenLogClientProperties {
    public static final String PREFIX = "openlog.ws";
    public static final String PROPERTY_ENABLE = PREFIX + "." + "enable";
    /**
     * 端点 连接地址
     */
    private String endpoint;
    /**
     * 连接数
     */
    private Integer socketSize = 1;
    /**
     * 心跳周期 单位 毫秒
     */
    private Integer heartCycle = 30000;
    /**
     * 线程池配置
     */
    private ThreadPoolConfig threadPoolConfig = new ThreadPoolConfig();

    @Data
    public static class ThreadPoolConfig {
        /**
         * 核心数
         */
        private Integer coreSize = 10;
        /**
         * 最大数
         */
        private Integer maxSize = 20;
        /**
         * 存活时间 单位毫秒
         */
        private Integer keepAlive = 1000;
        /**
         * 队列大小
         */
        private Integer queueSize = 10000;
        /**
         * 线程池前缀
         */
        private String threadPrefix;
    }
}
