/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.openlog.sdk;

import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;

public final class KeyValueMap
extends LinkedMultiValueMap<String, String> {
    private static final Logger log = LoggerFactory.getLogger(KeyValueMap.class);
    private static final String[] unmodified_keys = new String[]{"p", "mt"};

    public KeyValueMap() {
    }

    public KeyValueMap(int initialCapacity) {
        super(initialCapacity);
    }

    public KeyValueMap(Map<String, List<String>> otherMap) {
        super(otherMap);
    }

    public <T> T toSimpleObject(final Class<T> clazz) {
        return this.toSimpleObject(new Function<Map<String, String>, T>(){

            @Override
            public T apply(Map<String, String> stringStringMap) {
                return JsonHelper.convert((byte[])JsonHelper.convert2bytes(stringStringMap), (Class)clazz);
            }
        });
    }

    private <T> T toSimpleObject(Function<Map<String, String>, T> converter) {
        Map single = this.toSingleValueMap();
        return converter.apply(single);
    }

    public String getIp() {
        return (String)this.getFirst("ip");
    }

    public String getUa() {
        return (String)this.getFirst("ua");
    }

    public String getRef() {
        return (String)this.getFirst("refer");
    }

    public String getProduction() {
        return (String)this.getFirst("p");
    }

    public String getMt() {
        return (String)this.getFirst("mt");
    }

    public KeyValueMap deepCopy() {
        return this.deepCopy(new String[0]);
    }

    public KeyValueMap deepCopy(String ... withoutKey) {
        KeyValueMap map = new KeyValueMap(this.size());
        this.forEach((key, values) -> {
            if (Objects.isNull(withoutKey) || !ArrayUtils.contains((Object[])withoutKey, (Object)key)) {
                map.put((String)key, (List<String>)new LinkedList<String>((Collection<String>)values));
            }
        });
        return map;
    }

    public List<String> put(String key, String value) {
        List list = this.get(key);
        if (CollectionUtils.isEmpty((Collection)list)) {
            list = Lists.newArrayList();
        }
        list.add(value);
        return this.put(key, (List<String>)list);
    }

    public List<String> put(String key, List<String> value) {
        if (this.containsKey(key) && ArrayUtils.contains((Object[])unmodified_keys, (Object)key)) {
            throw new UnsupportedOperationException("Not allowed modify key: " + key);
        }
        return super.put((Object)key, value);
    }

    public void putAll(Map<? extends String, ? extends List<String>> map) {
        if (Objects.isNull(map)) {
            return;
        }
        Set<? extends String> keySet = map.keySet();
        for (String string : keySet) {
            if (!this.containsKey(string) || !ArrayUtils.contains((Object[])unmodified_keys, (Object)string)) continue;
            map.remove(string);
            if (!log.isWarnEnabled()) continue;
            log.warn("illegal key '{}', cause not allowed!", (Object)string);
        }
        super.putAll(map);
    }

    public List<String> remove(Object key) {
        if (ArrayUtils.contains((Object[])unmodified_keys, (Object)key)) {
            throw new UnsupportedOperationException("Not allowed remove key: " + key);
        }
        return super.remove(key);
    }

    public boolean remove(Object key, Object value) {
        if (ArrayUtils.contains((Object[])unmodified_keys, (Object)key)) {
            throw new UnsupportedOperationException("Not allowed remove key: " + key);
        }
        return super.remove(key, value);
    }
}

