/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.openlog.sdk.listener;

import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.listener.LogSubscriber;
import com.bxm.openlog.sdk.serial.Serialization;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberMessageListener
implements SingleMessageListener {
    private static final Logger log = LoggerFactory.getLogger(SubscriberMessageListener.class);
    private final String id;
    private final String topic;
    private final String consumerId;
    private final Serialization serialization;
    private final Map<String, LogSubscriber> subscribers;

    SubscriberMessageListener(String id, String topic, String consumerId, Serialization serialization, Map<String, LogSubscriber> subscribers) {
        this.id = id;
        this.topic = topic;
        this.consumerId = consumerId;
        this.serialization = serialization;
        this.subscribers = subscribers;
    }

    public ConsumeStatus consume(Message message, Object context) {
        byte[] body = message.getBody();
        KeyValueMap keyValueMap = this.serialization.deserialize(body);
        String logMt = keyValueMap.getMt();
        LogSubscriber subscriber = this.subscribers.get(logMt);
        if (Objects.isNull(subscriber)) {
            if (log.isInfoEnabled()) {
                log.info("Cannot found subscriber by id: {} mt: {}", (Object)this.id, (Object)logMt);
            }
            return ConsumeStatus.CONSUME_SUCCESS;
        }
        return subscriber.consume(keyValueMap);
    }

    public String getTopic() {
        return this.topic;
    }

    public String getConsumerId() {
        return this.consumerId;
    }
}

