package com.bxm.openlog.sdk;

import org.apache.commons.lang.StringUtils;

/**
 * 业务产品枚举
 *
 * @author allen
 * @date 2021-09-27
 * @since 1.0
 */
public enum Production {

    /**
     * 互动广告
     */
    INADS("inads"),

    /**
     * 盘古
     */
    PANGU("pangu"),

    /**
     * RTB
     */
    RTB("rtb");

    private final String name;

    Production(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static Production of(String name) {
        if (StringUtils.isBlank(name)) {
            return null;
        }
        Production[] values = values();
        for (Production value : values) {
            if (StringUtils.equals(name.toUpperCase(), value.getName().toUpperCase())) {
                return value;
            }
        }
        throw new IllegalArgumentException("No enum constant: " + name);
    }
}
