package com.bxm.openlog.sdk.consts;

/**
 * @author allen
 * @date 2022-02-16
 * @since 1.0
 */
public final class Common {

    /**
     * 行为类型
     */
    public enum Mt {

        /**
         * oCPX 行为上报
         */
        oCpx_Reporting("1");

        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Mt of(String original) {
            Mt[] values = values();
            for (Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }
}
