package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;

/**
 * 互动广告常量定义
 *
 * @author allen
 * @date 2022-01-06
 * @since 1.0
 */
public final class Inads {

    /**
     * 行为类型
     */
    public enum Mt {

        /**
         * 中间页曝光
         */
        IndexShow("9"),

        /**
         * 活动页面曝光
         */
        ActivityPageShow("3"),

        /**
         * 参加活动
         */
        ActivityAttend("4"),

        /**
         * 广告请求
         */
        AdRequest("5"),

        /**
         * 广告曝光
         */
        AdShow("6"),

        /**
         * 广告点击
         */
        AdClick("7");

        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Mt of(String original) {
            Mt[] values = values();
            for (Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }

    /**
     * 行为参数
     */
    public interface Param extends ProductionCommonParam {

        String BXMID = "bxmid";
        String UID = "uid";
        String TIME = "time";
        String ADID = "adid";
        String TAGID = "tagid";
        String CREATEID = "createid";
        String IP = "ip";
        String OS = "os";
        String UA = "ua";
    }
}
