package com.bxm.openlog.sdk;

/**
 * 系统常量
 *
 * @author allen
 * @date 2021-09-27
 * @since 1.0
 */
public class Constants {

    /**
     * Adx 服务商定义
     */
    public enum Adx {

        /**
         * 未知
         */
        Unknown(0),

        /**
         * 百度 BES
         */
        Bes(1),

        /**
         * 变现猫
         */
        Bxm(2),

        /**
         * 快手
         */
        Kuaishou(3),

        /**
         * 多盟
         */
        Domob(4),

        /**
         * 讯飞
         */
        Iflytek(5),

        /**
         * 趣头条
         */
        QTT(6),

        /**
         * Oppo
         */
        OPPO(7),

        /**
         * 喜马拉雅
         */
        XM(8);

        private final int id;

        Adx(int id) {
            this.id = id;
        }

        public static Adx of(int id) {
            Adx[] values = values();
            for (Adx value : values) {
                if (id == value.id) {
                    return value;
                }
            }
            return Unknown;
        }

        public int getId() {
            return id;
        }
    }
}
