package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;

/**
 * 互动广告常量定义
 *
 * @author allen
 * @date 2022-01-06
 * @since 1.0
 */
public final class Inads {

    /**
     * 行为类型
     */
    public enum Mt {

        /**
         * 中间页曝光
         */
        IndexShow("9"),

        /**
         * 活动页面曝光
         */
        ActivityPageShow("3"),

        /**
         * 参加活动
         */
        ActivityAttend("4"),

        /**
         * 广告请求
         */
        AdRequest("5"),

        /**
         * 广告曝光
         */
        AdShow("6"),

        /**
         * 广告点击
         */
        AdClick("7");

        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Mt of(String original) {
            Mt[] values = values();
            for (Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }

    /**
     * 行为参数
     * <a href="https://bxmrds.yuque.com/mizhsy/eqfqab/lr4exg">最新说明请参考文档</a>
     */
    public interface Param extends ProductionCommonParam {

        String BXMID = "bxmid";
        String UID = "uid";
        String ADID = "adid";
        String TAGID = "tagid";
        String CREATEID = "createid";
        String OS = "os";
        String SPM = "spm";
        String ACTIVITYID = "activityid";
        /**
         * 弹窗类型
         */
        String SCENE = "scene";
        String X = "x";
        String Y = "y";
        /**
         * 宽,高
         */
        String WH = "wh";
        String POPUPID = "popupid";
        /**
         * 单位：厘，无小数点
         */
        String OFFER_PRICE = "offer_price";
        String EXT = "ext";
        String DOMAIN = "domain";
        String ACTYPE = "actype";

        String ADURL = "adurl";
        String ICONID = "iconid";

        String FM_MODEL_ID = "fm_model_id";
        String WOKEID = "wokeid";
        /**
         * 1 直投、0 或空 非直投
         */
        String SRC_TYPE = "src_type";
        String LANDID = "landid";
        String EN_ADID = "en_adid";
        String EN_CID = "en_cid";
        String ADX_APPID = "adx_appid";
        String SSP_APPID = "ssp_appid";
        String SSP_TAGID = "ssp_tagid";

        String ATPID = "atpid";
        String OCPA_OFFER_PRICE = "ocpa_offer_price";
        String TARGET_CONV_TYPE = "target_conv_type";
        String SETTLE_TYPE = "settle_type";
        String PICID = "picid";

        String REMAIN_TIME = "remain_time";
        String CLICK_AREA = "click_area";
        String CLICK_LOCATION = "click_location";
        String TOID = "toid";
        String VENUEID = "venueid";
        String TAG_CID = "tag_cid";
        String BAN = "ban";
    }
}
