package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;

/**
 * 千里眼
 *
 * <a href="https://bxmrds.yuque.com/mizhsy/eqfqab/fhwkyv>参考详情</a>
 *
 * @author allen
 * @date 2022-02-18
 * @since 1.0
 */
public final class Kmeye {

    /**
     * 行为类型
     */
    public enum Mt {

        /**
         * 异常上报
         */
        Exception("1"),

        /**
         * 性能上报
         */
        Performance("2");

        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Mt of(String original) {
            Mt[] values = values();
            for (Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }

    public interface Param extends ProductionCommonParam {

        String LOCAL_URL = "local_url";
        String E_URL = "e_url";
        String LINE_NUM = "ln";
        String COLUMN_NUM = "cn";
        String MSG = "msg";
        String TS = "ts";
        String TYPE = "type";

        String PERFORMANCE = "performance";

        String OS_NAME = "osn";
        String OS_VERSION = "osv";
    }
}
