package com.bxm.openlog.sdk.params;

/**
 * 产品线的通用参数
 *
 * @author allen
 * @date 2021-11-05
 * @since 1.0
 */
public interface ProductionCommonParam extends PublicParam {

    /**
     * 时间戳，毫秒
     */
    String TIME = "time";

    /**
     * 加密后的设备标识。
     * <a href="https://bxmrds.yuque.com/staff-pe8atq/eqfqab/bf0zfq">参考资料</a>
     */
    String DEVICE = "device";

    String IMEI = "imei";
    String IMEI_MD5 = "imei_md5";
    String ANDROIDID = "androidid";
    String ANDROIDID_MD5 = "androidid_md5";
    String OAID = "oaid";
    String OAID_MD5 = "oaid_md5";
    String IDFA = "idfa";
    String IDFA_MD5 = "idfa_md5";

    /**
     * 国家
     */
    String COUNTRY = "country";
    /**
     * 省
     */
    String PROVINCE = "province";
    /**
     * 市
     */
    String CITY = "city";
    /**
     * 区县
     */
    String COUNTY = "county";
    /**
     * 运营商
     */
    String ISP = "isp";

    /**
     * 浏览器类型
     */
    String BROWSER = "browser";
    /**
     * 设备品牌。如：Huawei、OPPO
     */
    String DEVICE_BRAND = "device_brand";
    /**
     * 设备名称。如：Mate 30 Pro
     */
    String DEVICE_NAME = "device_name";
    /**
     * 设备类型。
     */
    String DEVICE_TYPE = "device_type";
    /**
     * 系统版本。如：Android 9
     */
    String OS_DETAIL = "os_detail";
    /**
     * 网络类型。如：4G、Wifi
     */
    String NET_TYPE = "net_type";
}
