package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;

/**
 * RTB 的常量定义
 *
 * @author allen
 * @date 2021-11-09
 * @since 1.0
 */
public final class Rtb {

    /**
     * Rtb 服务商定义
     */
    public enum Type {

        /**
         * 快手
         */
        Kuaishou("1"),

        /**
         * Lagesi
         */
        Lagesi("2");

        private final String id;

        Type(String id) {
            this.id = id;
        }

        public static Type of(String id) {
            Type[] values = values();
            for (Type value : values) {
                if (value.id.equals(id)) {
                    return value;
                }
            }
            return null;
        }

        public String getId() {
            return id;
        }
    }

    /**
     * Rtb 的行为类型定义
     */
    public enum Mt {

        /**
         * 转化回传
         */
        Conversion("1");

        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Mt of(String original) {
            Mt[] values = values();
            for (Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }

    /**
     * Rtb 的参数定义
     */
    public interface Param extends ProductionCommonParam {

        String RTB = "rtb";
        String BXMID = "bxmid";
        String TYPE = "type";
        String UID = "uid";
        String TIME = "time";
        String ADID = "adid";
        String TAGID = "tagid";
        String CREATEID = "createid";
        String IP = "ip";
        String OS = "os";
        String UA = "ua";
        String RTB_REQUEST_URI = "rtb_request_uri";
        String RTB_EVENT_TYPE = "rtb_event_type";
        String RTB_REQ_BODY = "rtb_req_body";
        String RTB_RES_BODY = "rtb_res_body";
        String RTB_RES_MSG = "rtb_res_msg";
    }
}
